<?php

// Include the main TCPDF library (search for installation path).
require_once('tcpdf_include.php');

// create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
//$pdf->SetAuthor('Nicola Asuni');
//$pdf->SetTitle('TCPDF Example 009');
//$pdf->SetSubject('TCPDF Tutorial');
//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
//$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 009', PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}

// -------------------------------------------------------------------

// add a page
$pdf->AddPage();

// set JPEG quality
$pdf->setJPEGQuality(100);

// Image method signature:
// Image($file, $x='', $y='', $w=0, $h=0, $type='', $link='', $align='', $resize=false, $dpi=300, $palign='', $ismask=false, $imgmask=false, $border=0, $fitbox=false, $hidden=false, $fitonpage=false)

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// Image example with resizing
$pdf->Text (10, 10, 'T_1_1_1500px_PNG8', $fstroke=false, $fclip=false, $ffill=true, $border=0, $ln=0, $align='', $fill=false, $link='', $stretch=0, $ignore_min_height=false, $calign='T', $valign='M', $rtloff=false);
$pdf->Image('../test_img_pdf/T_1_1_1500px_PNG8_Page_01_01.jpg', 10, 20, 200, 0, 'JPG', '', '', false, 300, 'L', false, false, 0, false, false, false);


// Image example with resizing
$pdf->Text (10, 60, 'T_1_1_png_1500px', $fstroke=false, $fclip=false, $ffill=true, $border=0, $ln=0, $align='', $fill=false, $link='', $stretch=0, $ignore_min_height=false, $calign='T', $valign='M', $rtloff=false);
$pdf->Image('../test_img_pdf/T_1_1_1500px_Page_01_10.png', 10, 70, 200, 0, 'PNG', '', '', false, 300, 'L', false, false, 0, false, false, false);


// Image example with resizing
$pdf->Text (10, 110, 'T_1_A_png', $fstroke=false, $fclip=false, $ffill=true, $border=0, $ln=0, $align='', $fill=false, $link='', $stretch=0, $ignore_min_height=false, $calign='T', $valign='M', $rtloff=false);
$pdf->Image('../test_img_pdf/T_1_A_01_01.png', 10, 120, 200, 0, 'PNG', '', '', false, 300, 'L', false, false, 0, false, false, false);


// Image example with resizing
$pdf->Text (10, 160, 'rozdzial_1_testowe-6_11.png', $fstroke=false, $fclip=false, $ffill=true, $border=0, $ln=0, $align='', $fill=false, $link='', $stretch=0, $ignore_min_height=false, $calign='T', $valign='M', $rtloff=false);
$pdf->Image('../test_img_pdf/rozdzial_1_testowe-6_11.png', 10, 170, 200, 0, 'PNG', '', '', false, 300, 'L', false, false, 0, false, false, false);


// Image example with resizing
$pdf->Text (10, 210, 'rozdzial_1_testowe-6_11.jpg', $fstroke=false, $fclip=false, $ffill=true, $border=0, $ln=0, $align='', $fill=false, $link='', $stretch=0, $ignore_min_height=false, $calign='T', $valign='M', $rtloff=false);
$pdf->Image('../test_img_pdf/rozdzial_1_testowe-6_11.jpg', 10, 220, 200, 0, 'JPG', '', '', false, 300, 'L', false, false, 0, false, false, false);

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


//Close and output PDF document
$pdf->Output('test_pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+